-- Skript zum Erkennen nicht indizierter Fremdschlüsselspalten
 with constraint_cols as (
       select b.table_name, a.constr_name, 
              a.pos, a.col_name,
              count(*) over (
                partition by constr_name) col_cnt
         from (select substr(
                        table_name,1,30) table_name,
                      substr(
                        constraint_name,1,30) constr_name,
                      substr(
                        column_name,1,30) col_name,
                      position pos
                 from user_cons_columns ) a,
              user_constraints b
        where a.constr_name = b.constraint_name
          and b.constraint_type = 'R')
select table_name tabelle, constr_name,
       listagg(col_name, ', ') 
       within group (order by col_name) spalten
  from constraint_cols cons
 where col_cnt > all
         ( select count(*)
             from user_ind_columns i
            where i.table_name = cons.table_name
              and i.column_name = col_name
              and i.column_position <= cons.col_cnt
            group by i.index_name
         )
 group by table_name, constr_name;
